# Formatting Digital Data Packs Using MAME's castool

## Abstract 

This document shows the process of applying formatting to suitable 
media without needing a donor tape to copy the formatting information. This 
process can be applied to either first-party media or to third-party media 
after the appropriate mechanical modifications are made to the cassette tape 
casing. This method requires only software to generate the required signal, and 
a suitable recording device to transfer the resulting signal to tape. Once 
transferred, the resulting tape can be used as any other digital data pack, for 
any required application. Applications for this method include 
lowest-common-denominator software distribution and reconstruction of degraded 
data packs so that they can be used again. 

This paper is split into two sections, the first providing an overview 
of the format of Coleco Adam Digital Data packs, while the second provides the 
procedure for formatting a data pack using the MAME castool. The first section 
may be skipped if the procedure is all that is needed.

This represents the long tail of collaborative work across multiple 
projects to solve a long term problem in the Adam community, and this paper 
would not have been possible without the efforts of many.

## Files

The main file you want is formatting-digital-data-packs.pdf, but I have also 
included the LyX and LaTeX source files to the paper.

Generated audio signal files are also provided for a completely blank DDP.
These are in tracks.zip

### Center Format (meant for EOS)
* [[center_track_a.wav]] Side A for a center formatted tape.
* [[center_track_b.wav]] Side B for a center formatted tape.

### Right Format (meant for Super Games)
* [[right_track_a.wav]] Side A for a right formatted tape.
* [[right_track_b.wav]] Side B for a right formatted tape.

## Author

Thom Cherryhomes
<thom.cherryhomes@gmail.com>
